﻿using System;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace ProxySample {
    internal class Program {
        public static async Task Run() {
            var proxy = new WebProxy("代理IP", 代理端口); //这里替换为你的代理地址和端口
			//如使用账号密码验证，反注释此行
            //proxy.Credentials = new NetworkCredential(userName: "账号", password: "密码"); //这里替换成你的验证用户名和密码

            //HttpWebRequest用法
            var req = HttpWebRequest.Create("https://baidu.com");
            req.Proxy = proxy;
            req.Method = "GET";
            var response = req.GetResponse();
            Stream stream = response.GetResponseStream();
            StreamReader sr = null;
            sr = new StreamReader(stream, Encoding.Default);
            var html = sr.ReadToEnd();
            sr.Close();
            sr.Dispose();
            Console.WriteLine(html);

            //HttpClient用法
            var httpClientHandler = new HttpClientHandler {
                Proxy = proxy,
            };
            HttpClient client = new HttpClient(httpClientHandler);
            var ret = await client.GetStringAsync("https://baidu.com");
            Console.WriteLine(ret);
        }

        public static void Main(string[] args) {
            Task.Run(async () => { await Program.Run(); }).Wait();
        }
    }
}