
package main

import (
	"fmt"
	"io/ioutil"
	"log"
	"net/http"
	"net/url"
	"time"
)

func main() {
	proxyAddr := "http://代理服务器ip:代理服务器http端口/"
	//账号密码验证
	//proxyAddr := "http://用户名:密码@代理服务器ip:代理服务器http端口/"

	//proxyAddr := "socks5://代理服务器ip:代理服务器http端口/"
	//proxyAddr := "socks5://用户名:密码@代理服务器ip:代理服务器http端口/"
	httpUrl := "http://myip.ipip.net"
	proxy, err := url.Parse(proxyAddr)
	if err != nil {
		log.Fatal(err)
	}
	netTransport := &http.Transport{
		Proxy:http.ProxyURL(proxy),
		MaxIdleConnsPerHost: 10,
		ResponseHeaderTimeout: time.Second * time.Duration(5),
	}
	httpClient := &http.Client{
		Timeout: time.Second * 10,
		Transport: netTransport,
	}
	res, err := httpClient.Get(httpUrl)
	if err != nil {
		log.Println(err)
		return
	}
	defer res.Body.Close()
	if res.StatusCode != http.StatusOK {
		log.Println(err)
		return
	}
	c, _ := ioutil.ReadAll(res.Body)
	fmt.Println(string(c))
}


            